\version "2.24.0"

\paper {
  %system-system-spacing = 0\mm
  system-system-padding = 5\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  bottom-margin = 5\mm
  top-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Doamne, buzele mele"
  subtitle = "(din Concertul coral Nr.1)"
  composer =  \markup \center-column { "Gavriil Musicescu" \small 
  "(1847–1903)" }
  meter = "Adagio"
  tagline=""
}

global = {
  \key ees \major
  %\autoBeamOff
  %\cadenzaOn
  \time 3/4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  Doam -- ne, bu -- ze -- le me -- le, bu -- ze -- le me -- le
  vei des -- chi -- de.
  Şi gu -- ra mea şi gu -- ra, gu -- ra va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea Şi gu -- 
  \set ignoreMelismata = ##t
  ra, gu -- \unset ignoreMelismata
  ra mea va ves -- ti la -- u -- da Ta,
  va ves -- ti la -- u -- da Ta. Gu -- ra mea va ves -- ti,
  va ves -- ti la -- u -- da Ta, va ves -- ti la -- u -- da Ta!
}

altWords = \lyricmode {
  Doam -- ne, bu -- ze -- le me -- le, bu -- ze -- le me -- le
  vei des -- chi -- de.
  Şi gu -- ra mea şi gu -- ra mea va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea, gu -- ra mea, Şi gu -- ra, gu -- ra va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea şi gu -- ra mea va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea va ves -- ti
  la -- u -- da Ta, va ves -- ti la -- u -- da Ta!
}

tenorWords = \lyricmode { 
  Doam -- ne, bu -- ze -- le me -- le, bu -- ze -- le me -- le
  vei des -- chi -- de.
  Şi gu -- ra mea şi gu -- ra mea va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea şi gu -- ra mea va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea, gu -- ra mea  va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea va ves -- ti,
  va ves -- ti la -- u -- da Ta, va ves -- ti la -- u -- da Ta!
}

bassWords = \lyricmode {
  Doam -- ne, Doam -- ne, bu -- ze -- le me -- le vei des -- chi -- de.
  Şi gu -- ra mea şi gu -- ra mea, gu -- ra mea va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea, gu -- ra mea şi gu -- ra mea va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea şi gu -- ra mea va ves -- ti la -- u -- da Ta.
  Şi gu -- ra mea va ves -- ti la -- u -- da Ta.
}

sopMusic = \relative c'' {
  r2. g2^\pp ees4 aes aes aes g2 g4
  f g aes bes( aes) g f( g) f ees2 ees8 r
  r2. ees'4 ees d c2 bes4 aes2 g4( g) f fis g g g f f f
  ees2 r4 r r 
  <<
      {
        \voiceOne
        ees'8([ d]) f2 ees4 ees( d)
      }
      \new Voice = "split" {
        \voiceTwo
        c8([ b]) d2 c4 c( b)
      }
  >>
  \oneVoice
  r4 r2. r r4 r 
   <<
      {
        \voiceOne
        b4 c( g') g( g) f
        \mark \markup { \large "gu - ra " } ees  
        d2 d4 ees( d c) d c b c
      }
      \new Voice = "split" {
        \voiceTwo
        b4 c2 bes4 aes8([ bes]) c([ d]) ees([ c]) d2 d4 ees( d c) d c b c
      }
  >>
  \oneVoice
  r r r2. r
  r r4 r aes g8([ aes bes g]) f([ ees]) f4 f f ees2 r4 aes( ees) f g2.
  aes4( ees) f g2. f4( aes) f g( ees g) f d f ees2. ees2 ees4 ees2. ees4 ees f
  <g ees>2.( <g ees>4) r2  
  \bar "|."
}

altMusic = \relative c' {
  r2. ees2 ees4 ees ees f ees2 ees4 ees2 ees8 ees f2 ees4 ees2 d4 ees2 bes8 r
  r2. g'4 g g g2 g4( g) f ees ees2. ees4 ees ees ees ees d
  ees r ees8([ f]) g4 g g( g) g g8([ fis]) g2 r4 r2. r2. r4 r g g2 g4
  aes2 g4( g) f aes g( f ees) f ees d d r r c8([ d ees f]) g ees aes2 aes4
  g2 g4 f8([ g aes bes]) c f, ees4 ees2( ees8[ d]) c([ bes]) c([ d]) ees2 r4 ees2. ees
  ees2. ees ees2 ees4 ees2. bes4 bes bes bes2. c2 ces4 bes2. c4 ces ces bes2.( bes4) r2
}

tenorMusic = \relative c' {
  r2. bes2 g4 c ces ces bes2 bes4 c2 c8 c bes2 bes4 c2 aes4 g2 g8 r
  r2. c4 c b c2 c4 c2 c4 c2. bes4 bes bes bes bes aes
  g2 r4 r2. r r r4 r 
  <<
      {
        \voiceOne
        ees'8([ d]) f2 ees4 ees( d) d
      }
      \new Voice = "split" {
        \voiceTwo
        c8([ b]) d2 c4 c( b) d
      }
  >>
  \oneVoice
  c2 c4
  c2. c2 c4 c g2 g g4 g r r r2. c8([ d ees f]) d bes
  bes4 ees ees c2. bes4 g8([ bes]) aes([ g]) aes4 aes aes g2 r4 c2. bes4( aes) bes
  c2. bes4( g) bes c2. bes4 g bes aes f aes g2. aes2 aes4 g2. aes4 aes aes g2.( g4) r2
  
}

bassMusic = \relative c {
  <ees ees,>2 <ees ees,>4 <ees ees,>2.( <ees ees,>) <ees ees,>
  <aes aes,>4 <g g,> <f f,>8([ <ees ees,>]) <d d,>2 <ees ees,>4
  aes,2 bes4 <ees ees,>2 <ees ees,>8 r8
  <ees ees,>4  <ees ees,> <d d,> <c c,>2 <d d,>4  <ees ees,>  <ees ees,>
  <e e,> <f f,>2 <g g,>4 <aes aes,>2( <a a,>4) <bes bes,> <bes bes,> <bes bes,>
  bes, bes bes <ees ees,>2 r4 r2. r r4 r
  g4 g g g( g) g g8([ fis]) g2 g8([ f]) ees2 e4 
  f2( g4) aes2 f4 g2. g,4 g g c8([ d ees f]) g([ ees]) aes2 g4 f2 bes,4
  ees8([ f g aes]) bes([ g]) aes2. bes4 bes bes bes, bes bes 
  <ees ees,>2 <ees ees,>4 <ees ees,>2. <ees ees,>2.( <ees ees,>) <ees ees,>
  aes,4( f) aes bes2. bes4 bes bes 
  <ees ees,>2.( <ees ees,> <ees ees,> <ees ees,> <ees ees,> <ees ees,>4) r2  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \set Staff.instrumentName = #"S" 
     \new Voice { \global \sopMusic }
     \addlyrics { \sopWords }
    >>

    \new Staff <<
     \set Staff.instrumentName = #"A"  
     \new Voice { \global \altMusic }
     \addlyrics { \altWords  }
    >>
    
    \new Staff <<
     \set Staff.instrumentName = #"T"   
     \clef "G_8"
     \new Voice { \global \tenorMusic }
     \addlyrics { \tenorWords } 
    >>
     
    \new Staff <<
      \set Staff.instrumentName = #"B"
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 40
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
